using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using System.Web.Security.AntiXss;

public partial class BioLabInterpretation : BasePage
{
    private const string REFERRER_KEY = "BioLabInterpretation_Referrer";

    private static IReadOnlyList<string> _navigationSources = new List<string>
    {
        "/LabResultsInterpretation.aspx",
        "/LabResultsInterpretationLetters.aspx",
        "/PatientWorkflows.aspx"
    };

    private readonly LabResultsIntrprtnManager _labResultsIntrprtnManager;
    private readonly WorkflowCaseManager _workflowManager;

    private WKF_CASE_ACTIVITY _activity;
    private WKF_CASE_ACTIVITY _labKit;
    private WKF_CASE _wCase;
    private EFR_REFERRAL _referral;
    private PATIENT _patient;
    private STD_WKFACTIVITYST _activitySt;

    public BioLabInterpretation()
    {
        _labResultsIntrprtnManager = new LabResultsIntrprtnManager();
        _workflowManager = new WorkflowCaseManager();

        //Manager Save Notification Event Handler
        _labResultsIntrprtnManager.BOSaveSuccess += manager_BOSaveSuccess;

        NavigationSources = _navigationSources;
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        LabResultInterpretation1.OnCancelClick += LabResultInterpretation1_OnCancelClick;
        LabResultInterpretation1.OnSaveClick += LabResultInterpretation1_OnSaveClick;
        LabResultInterpretation1.OnInterpretComplete += LabResultInterpretation1_OnInterpretComplete;
        LabResultInterpretation1.OnPrintPatientLetter += LabResultInterpretation1_OnPrintPatientLetter;
        LabResultInterpretation1.OnPrintProviderLetter += LabResultInterpretation1_OnPrintProviderLetter;
        LabResultInterpretation1.OnAddPrintQueue += LabResultInterpretation1_OnAddPrintQueue;
        lblSaveConfirmation.Visible = false;

        if (!IsPostBack)
        {
            int CaseId = Convert.ToInt32(AntiXssEncoder.HtmlEncode(Request.QueryString["CaseId"], false));
            BindData(CaseId);
            //TODO - Move breadcrumb logic to menubuilder and master page. Added here to avoid error out in Referral pages.

            SetOriginalReferringPage(REFERRER_KEY);
            SetReferringPage();
        }
    }

    void LabResultInterpretation1_OnPrintProviderLetter(object sender, EventArgs e)
    {
        Deserialize();
        if (GetInterpretationActivity().STD_WKFACTIVITYSTS_ID != Convert.ToInt16(WorkflowCaseActivityStatus.Interpreted)) SaveData(() => "Print");
        Response.Redirect(string.Format("LabResultsInterpretationLetters.aspx?activityId={0}&intActivityId={1}&RptType={2}&CaseId={3}", GetLabResult().WKF_CASE_ACTIVITY_ID, GetInterpretationActivity().WKF_CASE_ACTIVITY_ID, "1", _wCase.WKF_CASE_ID));
    }

    void LabResultInterpretation1_OnPrintPatientLetter(object sender, EventArgs e)
    {
        Deserialize();
        if (GetInterpretationActivity().STD_WKFACTIVITYSTS_ID != Convert.ToInt16(WorkflowCaseActivityStatus.Interpreted)) SaveData(() => "Print");
        Response.Redirect(string.Format("LabResultsInterpretationLetters.aspx?activityId={0}&intActivityId={1}&RptType={2}&CaseId={3}", GetLabResult().WKF_CASE_ACTIVITY_ID, GetInterpretationActivity().WKF_CASE_ACTIVITY_ID, "0", _wCase.WKF_CASE_ID));
    }

    void LabResultInterpretation1_OnInterpretComplete(object sender, EventArgs e)
    {
        Deserialize();

        SaveData(() => "Interpret");
        var master = this.Master as RegistryMaster;
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }

        BindData(_wCase.WKF_CASE_ID);

        WKF_CASE_ACTIVITY intActivity = _wCase.WKF_CASE_ACTIVITies.Where(s => s.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.Interpretation) && s.ARCHIVED_FLAG == false).Select(t => t).FirstOrDefault();
        if (intActivity != null && intActivity.INTERPRETATION_LETTERs.Count() > 0)
        {
            _labResultsIntrprtnManager.UpdateInterpretationLetterPrintQueue(intActivity.INTERPRETATION_LETTERs[0], false);
        }

        Redirect();
    }

    void LabResultInterpretation1_OnSaveClick(object sender, EventArgs e)
    {
        if (Page.IsValid)
        {
            Deserialize();
            SaveData(() => "Save");
            BindData(_wCase.WKF_CASE_ID);
        }
    }

    private void SaveData(Func<string> action)
    {
        Deserialize();

        _patient.SetAsChangeTrackingRoot(true);

        PatientLabInfo info = new PatientLabInfo();


        OpenCloseReferralAndWorkflowCase(action);
        if (action() == "Interpret")
        {
            CONTACT_LOG contact = CreateNewContact();
            _patient.REFERRALs.Where(s => s.REFERRAL_ID == _wCase.REFERRAL_ID).First().CONTACT_LOGs.Add(contact);
        }

        BioLabResultUserControl1.GetfieldValues(info);

        //Save interpretation results and addresses
        _activity.CONTACT_NAME = info.LabContact;

        if (_activity.SPECIMEN_ANALYSIs.Count() > 0)
        {
            _activity.SPECIMEN_ANALYSIs[0].LAB_UID_NUMBER = info.Accession;
            _activity.SPECIMEN_ANALYSIs[0].SPECIMEN_COLLECTION_DATE = Helpers.ToNullable<DateTime>(info.SpecColnDate);

            if (_activity.SPECIMEN_ANALYSIs[0].ANALYSIS_DETAILs.Count() > 0)
            {
                for (int i = 0; i < RepeaterAnalyteList.Items.Count; i++)
                {

                    HiddenField hiddenFieldAnalysisDetailId = (HiddenField)RepeaterAnalyteList.Items[i].FindControl("HiddenFieldAnalysisDetailId");

                    //get the ANALYSIS_DETAIL entity baseed on hiddenFieldAnalysisDetailId
                    ANALYSIS_DETAIL foundAnalysisDetail = (from e in _activity.SPECIMEN_ANALYSIs[0].ANALYSIS_DETAILs
                                                           where e.ANALYSIS_DETAIL_ID == Helpers.GetIntFromString(hiddenFieldAnalysisDetailId.Value)
                                                           select e).FirstOrDefault();

                    if (foundAnalysisDetail != null)
                    {
                        TextBox textBoxTEFSCReferenceRange = (TextBox)RepeaterAnalyteList.Items[i].FindControl("TextBoxTEFSCReferenceRange");
                        DropDownList dropDownListTEFSCReferenceRangeUnits = (DropDownList)RepeaterAnalyteList.Items[i].FindControl("DropDownListTEFSCReferenceRangeUnits");
                        RadioButtonList radioButtonListAboveTEFSCRefenceRange = (RadioButtonList)RepeaterAnalyteList.Items[i].FindControl("RadioButtonListAboveTEFSCRefenceRange");

                        if (textBoxTEFSCReferenceRange != null)
                        {
                            foundAnalysisDetail.TEFSC_REFERENCE_RANGE = textBoxTEFSCReferenceRange.Text;
                        }

                        if (dropDownListTEFSCReferenceRangeUnits != null)
                        {
                            foundAnalysisDetail.TEFSC_REFERENCE_RANGE_UNIT_ID = Helpers.ConvertStringToNullable<int>(dropDownListTEFSCReferenceRangeUnits.SelectedValue);
                        }

                        if (radioButtonListAboveTEFSCRefenceRange != null)
                        {
                            foundAnalysisDetail.TEFSC_ABOVE_REFERENCE_RANGE = Helpers.ConvertStringToNullable<int>(radioButtonListAboveTEFSCRefenceRange.SelectedValue);
                        }
                    }

                }
            }
        }

        //if (SetAsCompleted)
        if (action() == "Interpret")
        {
            GetInterpretationActivity().STD_WKFACTIVITYSTS_ID = Convert.ToInt16(WorkflowCaseActivityStatus.Interpreted);
        }
        else if (action() == "Save")
        {
            GetInterpretationActivity().STD_WKFACTIVITYSTS_ID =
                GetInterpretationActivity().STD_WKFACTIVITYSTS_ID ==
                    Convert.ToInt16(WorkflowCaseActivityStatus.Interpreted) ? Convert.ToInt16(WorkflowCaseActivityStatus.Interpreted) : Convert.ToInt16(WorkflowCaseActivityStatus.InProcess);

        }
        else
        {
            GetInterpretationActivity().STD_WKFACTIVITYSTS_ID = Convert.ToInt16(WorkflowCaseActivityStatus.InProcess);
        }

        //Check if the pre-populated patient address has been changed.
        LabResultInterpretation1.UpdateInterpretationDetails(_wCase);
        LabResultInterpretation1.SaveBioFollowUp(_wCase);
        //Call update from the interpretation manager
        _labResultsIntrprtnManager.UpdateInterpretationActivity(_patient);
        var master = this.Master as RegistryMaster;
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }
        //(this.Master as RegistryMaster).SetDirtyFlag(false);
    }

    void LabResultInterpretation1_OnCancelClick(object sender, EventArgs e)
    {
        Redirect();
    }

    void LabResultInterpretation1_OnAddPrintQueue(object sender, EventArgs e)
    {
        Deserialize();
        WKF_CASE_ACTIVITY intActivity = _wCase.WKF_CASE_ACTIVITies.Where(s => s.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.Interpretation) && s.ARCHIVED_FLAG == false).FirstOrDefault();
        if (intActivity.STD_WKFACTIVITYSTS_ID != Convert.ToInt16(WorkflowCaseActivityStatus.Interpreted)) SaveData(() => "Print");
        if (intActivity != null && intActivity.INTERPRETATION_LETTERs.Count() > 0)
        {
            _labResultsIntrprtnManager.UpdateInterpretationLetterPrintQueue(intActivity.INTERPRETATION_LETTERs[0], true);
        }
    }

    private void BindData(int caseId)
    {
        _wCase = _labResultsIntrprtnManager.GetLabInterpretationDetails(caseId);
        _activity = GetLabResult();

        _labKit = _workflowManager.SelectByActivityType(_wCase.WKF_CASE_ID, "LabKit");

        ViewState["LabKit"] = _labKit.Serialize();

        ViewState["_wCase"] = _wCase.Serialize();
        ViewState["Referral"] = _wCase.REFERRAL.Serialize();
        ViewState["Patient"] = _wCase.REFERRAL.PATIENT.Serialize();
        PatientLabInfo Info = new PatientLabInfo();
        if (_activity != null)
        {
            Info.WorkFlowCaseId = "";
            Info.Name = _activity.WKF_CASE.REFERRAL.PATIENT.FullName;
            Info.ID = _activity.WKF_CASE.REFERRAL.PATIENT.PATIENT_ID.ToString();
            Info.ICN = _activity.WKF_CASE.REFERRAL.PATIENT.PATIENT_ICN;
            Info.Snum = _activity.WKF_CASE.REFERRAL.PATIENT.Snum;
            Info.BirthDate = ConvertDateToString(_activity.WKF_CASE.REFERRAL.PATIENT.BIRTH_DATE);
            Info.Gender = _activity.WKF_CASE.REFERRAL.PATIENT.STD_GENDER.NAME;
            Info.PostalCode = _activity.WKF_CASE.REFERRAL.PATIENT.POSTAL_CODE;
            if (_activity.SPECIMEN_ANALYSIs.Count() > 0)
            {
                Info.ReportDate = ConvertDateToString(_activity.SPECIMEN_ANALYSIs[0].LAB_REPORT_DATE);
                //Info.Accession = "BSO " + _activity.SPECIMEN_ANALYSIs[0].BSO_NUMBER;
                //Info.Accession1 = _activity.SPECIMEN_ANALYSIs[0].LAB_UID_NUMBER;
                Info.Accession = _activity.SPECIMEN_ANALYSIs[0].LAB_UID_NUMBER;

                Info.LabName = _activity.SPECIMEN_ANALYSIs[0].LAB_NAME;
                if (Info.LabName == null)
                    Info.LabName = "Baltimore VA lab";
                Info.SpecColnDate = ConvertDateToString(_activity.SPECIMEN_ANALYSIs[0].SPECIMEN_COLLECTION_DATE);
                lblElapsedTime.Text = _activity.SPECIMEN_ANALYSIs[0].TIME_ELAPSED_NUMBER;
                lblTotalVol.Text = _activity.SPECIMEN_ANALYSIs[0].TOTAL_VOLUME_NUMBER;
                lblVolOfAnalyteTests.Text = _activity.SPECIMEN_ANALYSIs[0].ANALYTE_VOLUME_NUMBER;

                //Populate Analyte details
                if (_activity.SPECIMEN_ANALYSIs[0].ANALYSIS_DETAILs.Count() > 0)
                {
                    RepeaterAnalyteList.DataSource = _activity.SPECIMEN_ANALYSIs[0].ANALYSIS_DETAILs.OrderBy("SortByLabResults");

                    RepeaterAnalyteList.DataBind();
                }
            }

            //Bind provider,patient details
            //Populate patient updated address
            LabResultInterpretation1.PopulatePatientProviderDetails(_wCase, "Bio");
            LabResultInterpretation1.PopulateBioFollowUp(_wCase);

            Info.LabContact = _activity.CONTACT_NAME;

            if (_labKit == null)
                _labKit = ViewState["LabKit"] as WKF_CASE_ACTIVITY;
            //Info.ReportDate = ConvertDateToString(order.LAB_ORDERs.FirstOrDefault().LAB_RETURN_DATE);
            if (_labKit != null)
                Info.KitReceivedDate = _labKit.SHIPPING_DETAILs.First().RECEIVED_DATE.HasValue ? _labKit.SHIPPING_DETAILs.First().RECEIVED_DATE.Value.ToString("d") : String.Empty;

            WKF_CASE_ACTIVITY intActivity = _wCase.WKF_CASE_ACTIVITies.Where(e => e.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.Interpretation)
                && e.ARCHIVED_FLAG == false).FirstOrDefault();
            _activitySt = intActivity.STD_WKFACTIVITYST;
            ViewState["OrderType"] = _activitySt.ID;

            bool linkwfs = intActivity.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.New ||
                 intActivity.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.InProcess;

            BioLabResultUserControl1.SetfieldValues(Info, linkwfs);

            BreadCrumbLabel.Text = "My Tasks > Interpretation & Follow Up > " + _activitySt.NAME + " > Workflow ID " + _wCase.WKF_CASE_ID;
        }

    }

    protected void RepeaterAnalyteList_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {

        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            DropDownList dropDownListTEFSCReferenceRangeUnits = e.Item.FindControl("DropDownListTEFSCReferenceRangeUnits") as DropDownList;
            Panel panelAboveTEFSCReferenceRange = e.Item.FindControl("PanelAboveTEFSCReferenceRange") as Panel;
            RequiredFieldValidator requiredFieldValidatorForRadioButtonListAboveTEFSCRefenceRange = e.Item.FindControl("RequiredFieldValidatorForRadioButtonListAboveTEFSCRefenceRange") as RequiredFieldValidator;
            Label labelLabReferenceRange = e.Item.FindControl("LabelLabReferenceRange") as Label;
            Label labelLabAboveReferenceRange = e.Item.FindControl("LabelLabAboveReferenceRange") as Label;
            Label labelResultReferenceUnit = e.Item.FindControl("LabelResultReferenceUnit") as Label;

            ANALYSIS_DETAIL currentAnalysisDetail = (ANALYSIS_DETAIL)e.Item.DataItem;

            //set the TEFSC reference range unit drop down
            if (currentAnalysisDetail.TEFSC_REFERENCE_RANGE_UNIT_ID.HasValue)
            {
                if (dropDownListTEFSCReferenceRangeUnits != null)
                {
                    dropDownListTEFSCReferenceRangeUnits.SelectedValue = currentAnalysisDetail.TEFSC_REFERENCE_RANGE_UNIT_ID.Value.ToString();
                }
            }

            //set the above TEFSC reference range radio button list value
            if (currentAnalysisDetail.TEFSC_ABOVE_REFERENCE_RANGE.HasValue)
            {
                RadioButtonList radioButtonListAboveTEFSCRefenceRange = e.Item.FindControl("RadioButtonListAboveTEFSCRefenceRange") as RadioButtonList;
                if (radioButtonListAboveTEFSCRefenceRange != null)
                {
                    radioButtonListAboveTEFSCRefenceRange.SelectedValue = currentAnalysisDetail.TEFSC_ABOVE_REFERENCE_RANGE.Value.ToString();
                }
            }

            if (currentAnalysisDetail.LAB_REFERENCE_RANGE == "") //|| currentAnalysisDetail.STD_UNIT.CODE == "N/A")
            {
                if (labelResultReferenceUnit != null && labelLabReferenceRange != null)
                {
                    labelLabReferenceRange.Text
                    //    = labelLabAboveReferenceRange.Text 
                    = labelResultReferenceUnit.Text
                    = "N/A";
                }
            }


            bool ShowTEFSCReferenceRangeReadOnly = true;

            Label labelforTextBoxTEFSCReferenceRange = e.Item.FindControl("LabelforTextBoxTEFSCReferenceRange") as Label;
            Label labelforLabelTEFSCReferenceRange = e.Item.FindControl("LabelforLabelTEFSCReferenceRange") as Label;
            TextBox textBoxTEFSCReferenceRange = e.Item.FindControl("TextBoxTEFSCReferenceRange") as TextBox;
            Label labelTEFSCReferenceRange = e.Item.FindControl("LabelTEFSCReferenceRange") as Label;
            Label labelforDropDownListTEFSCReferenceRangeUnits = e.Item.FindControl("LabelforDropDownListTEFSCReferenceRangeUnits") as Label;
            Label labelforLabelTEFSCReferenceRangeUnits = e.Item.FindControl("LabelforLabelTEFSCReferenceRangeUnits") as Label;
            //DropDownList dropDownListTEFSCReferenceRangeUnits = e.Item.FindControl("DropDownListTEFSCReferenceRangeUnits") as DropDownList;
            Label labelTEFSCReferenceRangeUnits = e.Item.FindControl("LabelTEFSCReferenceRangeUnits") as Label;


            if (currentAnalysisDetail.STD_ANALYTETYPE == null || currentAnalysisDetail.STD_ANALYTETYPE.CODE == "OTHER")
            {
                ShowTEFSCReferenceRangeReadOnly = false;
            }
            else
            {
                ShowTEFSCReferenceRangeReadOnly = true;
            }

            //show TEFSC reference range read only label and associated controls
            if (labelTEFSCReferenceRange != null && labelforLabelTEFSCReferenceRangeUnits != null && labelTEFSCReferenceRangeUnits != null && labelforLabelTEFSCReferenceRange != null)
            {
                labelforLabelTEFSCReferenceRange.Visible
                    = labelTEFSCReferenceRange.Visible
                    = labelforLabelTEFSCReferenceRangeUnits.Visible
                    = labelTEFSCReferenceRangeUnits.Visible
                    = ShowTEFSCReferenceRangeReadOnly;
            }


            //show TEFSC reference range text box and associated controls
            if (textBoxTEFSCReferenceRange != null && labelforDropDownListTEFSCReferenceRangeUnits != null && dropDownListTEFSCReferenceRangeUnits != null && labelforTextBoxTEFSCReferenceRange != null)
            {
                labelforTextBoxTEFSCReferenceRange.Visible
                = textBoxTEFSCReferenceRange.Visible
                = labelforDropDownListTEFSCReferenceRangeUnits.Visible
                = dropDownListTEFSCReferenceRangeUnits.Visible

                = !ShowTEFSCReferenceRangeReadOnly;

            }


            if (currentAnalysisDetail.STD_TEST_NAME != null && currentAnalysisDetail.STD_TEST_NAME.CODE == "STANDARDIZED")
            {
                if (panelAboveTEFSCReferenceRange != null)
                {
                    panelAboveTEFSCReferenceRange.Visible = true;
                }
                if (requiredFieldValidatorForRadioButtonListAboveTEFSCRefenceRange != null)
                {
                    requiredFieldValidatorForRadioButtonListAboveTEFSCRefenceRange.Enabled = true;
                    requiredFieldValidatorForRadioButtonListAboveTEFSCRefenceRange.ErrorMessage
                        = "Above TEFSC Reference Range Required for "
                        + currentAnalysisDetail.STD_TEST_NAME.CODE.ToString()
                        + " "
                        + currentAnalysisDetail.ANALYTE_NAME;
                }


            }
            else
            {
                if (panelAboveTEFSCReferenceRange != null)
                {
                    panelAboveTEFSCReferenceRange.Visible = false;
                }
                if (requiredFieldValidatorForRadioButtonListAboveTEFSCRefenceRange != null)
                {
                    requiredFieldValidatorForRadioButtonListAboveTEFSCRefenceRange.Enabled = false;
                }
            }
        }
    }

    private WKF_CASE_ACTIVITY GetInterpretationActivity()
    {
        return _wCase.WKF_CASE_ACTIVITies.Where(a => a.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.Interpretation) && a.ARCHIVED_FLAG == false).Select(t => t).FirstOrDefault();
    }
    private WKF_CASE_ACTIVITY GetLabResult()
    {
        return _wCase.WKF_CASE_ACTIVITies.Where(e => e.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.LabResult) && e.STD_WKFACTIVITYSTS_ID == Convert.ToInt16(WorkflowCaseActivityStatus.Accepted) && e.ARCHIVED_FLAG == false).Select(t => t).FirstOrDefault();
    }

    private void Deserialize()
    {
        _wCase = SerializerUtil.Deserialize<WKF_CASE>((string)ViewState["_wCase"]);
        _referral = SerializerUtil.Deserialize<EFR_REFERRAL>((string)ViewState["Referral"]);
        _patient = SerializerUtil.Deserialize<PATIENT>((string)ViewState["Patient"]);
        _wCase.REFERRAL = _referral;
        _wCase.REFERRAL.PATIENT = _patient;
        _activity = GetLabResult();
    }


    private void OpenCloseReferralAndWorkflowCase(Func<string> operation)
    {
        ReferralManager rm = new ReferralManager();

        EFR_REFERRAL parentReferral = rm.getReferralByReferralID(_wCase.REFERRAL_ID.Value);

        if (operation() == "Interpret")
        {
            _wCase.STD_WKFCASESTS_ID = (int)WorkFlowCaseStatus.Completed;
            var items = parentReferral.WKF_CASEs.Except(new List<WKF_CASE> { _wCase }, new WorkflowCaseManager.WorkflowCaseComparer());


            if (items.Count(a => a.STD_WKFCASESTS_ID != (int)WorkFlowCaseStatus.Completed) == 0)

                _referral.STD_REFERRALSTS_ID = (int)ReferralStatus.Completed;
        }
        else
        {
            if (_referral.STD_REFERRALSTS_ID != (int)ReferralStatus.InProcess)
                _referral.STD_REFERRALSTS_ID = (int)ReferralStatus.InProcess;


            if (_wCase.STD_WKFCASESTS_ID != (int)WorkFlowCaseStatus.InProcess)
                _wCase.STD_WKFCASESTS_ID = (int)WorkFlowCaseStatus.InProcess;

        }
    }

    private CONTACT_LOG CreateNewContact()
    {

        CONTACT_LOG contact = new CONTACT_LOG();

        contact.REFERRAL_ID = _wCase.REFERRAL_ID.Value;
        contact.CONTACT_FIRST_NAME = _patient.FIRST_NAME;
        contact.CONTACT_LAST_NAME = _patient.LAST_NAME;
        contact.CONTACT_DATE = DateTime.Now;
        contact.CONTACT_METHOD_TEXT = "Mail";
        contact.CONTACT_EMAIL = null;
        contact.CONTACT_ADDR1 = _patient.ADDRESS_LINE1;
        contact.CONTACT_ADDR2 = _patient.ADDRESS_LINE2;
        contact.CONTACT_ADDR3 = _patient.ADDRESS_LINE3;
        contact.CONTACT_CITY = _patient.CITY;
        contact.CONTACT_STATE = _patient.STATE;
        contact.CONTACT_POSTAL = _patient.POSTAL_CODE;
        contact.CONTACT_ZIPPLUS4 = _patient.ZIP_PLUS_4;
        contact.CONTACT_COUNTRY = _patient.COUNTRY;
        contact.CONTACT_REASON_TEXT = "Interpretation Letter Printed";
        contact.TELEMEDICINE_PATIENT_FLAG = false;
        contact.TELEMEDICINE_PROVIDER_FLAG = false;
        contact.INPATIENT_EVAL_RECOM_FLAG = false;
        contact.CONTACT_MESSAGE_TEXT = @"Interpretation Letter was printed by " +
            System.Threading.Thread.CurrentPrincipal.Identity.Name +
            @" The interpretation letter was sent to both the patient 
               indicated above, 
               and the provider as indicated on the interpretation screen.";

        return contact;
    }
    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "EFR_LABINTERPRETATION";
    }

    public override string AppObjectCode()
    {
        return "EFR_LABINTERPRETATION";
    }

    private void Redirect()
    {
        RedirectToOriginalReferringPage(REFERRER_KEY); 
    }

}


